package org.msh.tb.bd.tbforms.dhis2.tb10;

import org.msh.tb.entities.enums.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 20/02/2017.
 * Mock data for each block of Tb 10 Form.
 * Used to test if all data elements and COCs Ids are correct.
 * To run this test need to change code on TB10AsyncTask to use the mock data generated by this class.
 */
public class Tb10MockDataResource {

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 1 will have its values starting by 1 from left -> right up -> down
     * ex:
     * 1 - 2 - 3 - 4 ...
     * 37 - 38 - 39 - 40 - 41 ...
     * ...
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block1(boolean setAsZero) {

        List<Object[]> results = new ArrayList<Object[]>();

        Integer[] ages = new Integer[] {2, 6, 16, 26, 36, 46, 56, 66};

        InfectionSite[] infectionSites = new InfectionSite[]{InfectionSite.PULMONARY,
                InfectionSite.EXTRAPULMONARY};

        CaseDefinition[] caseDefinitions = new CaseDefinition[]{CaseDefinition.BACTERIOLOGICALLY_CONFIRMED,
                CaseDefinition.CLINICALLY_DIAGNOSED};

        PatientType[] patientTypes = new PatientType[] {PatientType.UNKNOWN_PREVIOUS_TB_TREAT,
                PatientType.NEW,
                PatientType.PREVIOUSLY_TREATED};

        PatientType[] prevTreatPatientTypes = new PatientType[] {PatientType.RELAPSE,
                PatientType.TREATMENT_AFTER_FAILURE,
                PatientType.TREATMENT_AFTER_LOSS_FOLLOW_UP,
                PatientType.OTHER_PREVIOUSLY_TREATED};

        Gender[] genders = new Gender[] {Gender.MALE,
                Gender.FEMALE};

        long count = setAsZero ? 0 : 1;

        for (Integer age : ages) {
            for (InfectionSite is : infectionSites) {
                for (CaseDefinition cd : caseDefinitions) {
                    if (is.equals(InfectionSite.EXTRAPULMONARY) && cd.equals(CaseDefinition.CLINICALLY_DIAGNOSED)) {
                        break;
                    }

                    for (PatientType pt : patientTypes) {

                        if (PatientType.PREVIOUSLY_TREATED.equals(pt)) {
                            for (PatientType prevPt : prevTreatPatientTypes) {
                                for (Gender gender : genders) {
                                    Object[] result = new Object[]{pt,
                                            prevPt,
                                            cd,
                                            is,
                                            age,
                                            gender,
                                            count};

                                    results.add(result);

                                    count = getNext(count, setAsZero);
                                }
                            }
                        } else {
                            for (Gender gender : genders) {
                                Object[] result = new Object[]{pt,
                                        null,
                                        cd,
                                        is,
                                        age,
                                        gender,
                                        count};

                                results.add(result);

                                count = getNext(count, setAsZero);
                            }
                        }
                    }
                }
            }
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 2 will have its values starting by 5 from left -> right
     * ex:
     * 5 - 6 - 7 - 8 - 9 - 10 - 11...
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block2(boolean setAsZero) {
        List<String> dots = new ArrayList<String>();

        dots.add("pGraduatePract");
        dots.add("NonpGraduatePract");
        dots.add("GovFieldStaff");
        dots.add("ShasthoShebika");
        dots.add("VillageDoctor");
        dots.add("CommVolunteer");
        dots.add("GovtHospital");
        dots.add("PrivateHospital");
        dots.add("CHCP");
        dots.add("TBPatient");
        dots.add("Other");

        List<Object[]> results = new ArrayList<Object[]>();

        long count = setAsZero ? 0 : 5;

        for (String dotId : dots) {
            Object[] result = new Object[]{dotId, null, count};
            results.add(result);

            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 3 will have its values starting by 6 from left -> right
     * ex:
     * 6 - 7 - 8 - 9 - 10 - 11...
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block3(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK3_FIELD1,
                TbFormField.TB10_BLOCK3_FIELD2,
                TbFormField.TB10_BLOCK3_FIELD3,
                TbFormField.TB10_BLOCK3_FIELD4
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 6;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 4 will have its values starting by 4 from left -> right
     * ex:
     * 4 - 5 - 6 - 7 - 8 - 9 - 10 - 11...
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block4(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK4_FIELD1,
                TbFormField.TB10_BLOCK4_FIELD2,
                TbFormField.TB10_BLOCK4_FIELD3,
                TbFormField.TB10_BLOCK4_FIELD4
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 4;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 5A will have its values starting by 3 from left -> right up -> down
     * ex:
     * 02 - 04 - 01 - 02
     * 06 - 08 - 03 - 04
     * 10 - 12 - 05 - 06
     * 14 - 16 - 07 - 08
     * ...
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block5a(boolean setAsZero) {
        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 1;

        // row 1
        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.BACTERIOLOGICALLY_CONFIRMED,
                Gender.MALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.BACTERIOLOGICALLY_CONFIRMED,
                Gender.MALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.BACTERIOLOGICALLY_CONFIRMED,
                Gender.FEMALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.BACTERIOLOGICALLY_CONFIRMED,
                Gender.FEMALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        // row 2
        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.PULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        // row 3
        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.NEW,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);


        // row 4
        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.PREVIOUSLY_TREATED,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.PREVIOUSLY_TREATED,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.MALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);
        count = getNext(count, setAsZero);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.PREVIOUSLY_TREATED,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.NEGATIVE,
                setAsZero ? 0 : count};
        results.add(res);

        res = new Object[]{InfectionSite.EXTRAPULMONARY,
                PatientType.PREVIOUSLY_TREATED,
                CaseDefinition.CLINICALLY_DIAGNOSED,
                Gender.FEMALE,
                HIVResult.POSITIVE,
                setAsZero ? 0 : count};
        results.add(res);

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 5B will have its values starting by 2 from left -> right
     * ex:
     * 2-3-4-5
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block5b(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK5B_FIELD1,
                TbFormField.TB10_BLOCK5B_FIELD2,
                TbFormField.TB10_BLOCK5B_FIELD3,
                TbFormField.TB10_BLOCK5B_FIELD4
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 2;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 6A will have its values starting by 4 from left -> right
     * ex:
     * 4-5
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block6a(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK6A_FIELD1,
                TbFormField.TB10_BLOCK6A_FIELD2
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 4;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 6B will have its values starting by 3 from left -> right
     * ex:
     * 3-4
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block6b(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK6B_FIELD1,
                TbFormField.TB10_BLOCK6B_FIELD2
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 3;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * If setAsZero all fields will be sent as zero. If not:
     * Expected result is that cells in TB 10 Form Block 6C will have its values starting by 2 from left -> right
     * ex:
     * 2-3
     * @param setAsZero
     * @return
     */
    public static List<Object[]> block6c(boolean setAsZero) {
        TbFormField[] fields = new TbFormField[] {
                TbFormField.TB10_BLOCK6C_FIELD1,
                TbFormField.TB10_BLOCK6C_FIELD2
        };

        List<Object[]> results = new ArrayList<Object[]>();
        Object[] res;
        long count = setAsZero ? 0 : 2;

        for (TbFormField field : fields) {
            res = new Object[]{field, new Long(count).intValue()};
            results.add(res);
            count = getNext(count, setAsZero);
        }

        return results;
    }

    /**
     * Check if setAsZero is true, if it is return zero, if not returns current value + 1
     * @param currentValue
     * @param setAsZero
     * @return
     */
    private static Long getNext(Long currentValue, boolean setAsZero) {
        if (setAsZero) {
            return new Long(0);
        }

        return currentValue + 1;
    }
}
